<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Transaction extends Model
{
    use SoftDeletes;

    protected $dates = ['deleted_at'];

    // Helpful relations if not present:
    public function contact()
    {
        return $this->belongsTo(\App\Models\Contact::class, 'contact_id');
    }

    public function location()
    {
        return $this->belongsTo(\App\Models\BusinessLocation::class, 'location_id');
    }

    public function lines()
    {
        return $this->hasMany(\App\Models\TransactionSellLine::class, 'transaction_id');
    }

    public function payments()
    {
        return $this->hasMany(\App\Models\TransactionPayment::class, 'transaction_id');
    }
}
